function postData ( params )
{
    var formData = new FormData();
    for ( var key in params.data )
    {
        formData.append ( key , params.data[key] );
    }
    fetch ( params.url , {
      method: params.method, // *GET, POST, PUT, DELETE, etc.
      mode: 'cors', // no-cors, *cors, same-origin
      cache: 'no-cache', // *default, no-cache, reload, force-cache, only-if-cached
      credentials: 'same-origin', // include, *same-origin, omit
      redirect: 'follow', // manual, *follow, error
      referrerPolicy: 'no-referrer', // no-referrer, *no-referrer-when-downgrade, origin, origin-when-cross-origin, same-origin, strict-origin, strict-origin-when-cross-origin, unsafe-url
      body: formData // body data type must match "Content-Type" header
    } ).then ( response => response.json() ).then ( data => {
        params.complete ( { responseJSON: data } , 'success' );
    }
    ).catch ( error => {
        console.log ( error );
        params.complete ( {} , 'error' );
    } );
    
}