/**
 *  Background communication
 */

function sendMessage ( message , callback )
{
    chrome.runtime.sendMessage ( { data: message } , callback );
}
 
function sendCommand ( cmd , params , callback )
{
    sendMessage ( { cmd: cmd , params: params } , callback );
}
 
var params = {};
var search = document.location.search;
if ( search.indexOf ( '?' ) == 0 )
{
    search = search.substr ( 1 );
}
var pares = search.split ( /&/ );
pares.forEach ( element => {
    if ( element.indexOf ( '=' ) != -1 )
    {
        params [ element.substring ( 0 , element.indexOf ( '=' ) ) ] = element.substring ( element.indexOf ( '=' ) + 1 );
    }
} );


var claim_data;
var claim_verification;
var filesReading = 0;

function sendVerification()
{
    if ( filesReading > 0 )
    {
        window.setTimeout ( sendVerification , 500 );
    }
    else
    {
        document.verify.claim_data.value = serializeObject ( claim_data );
        document.verify.timestamp.value = parseInt ( new Date().getTime() / 1000 );
        sendCommand ( 'createRequestProof' , { data: { claim_data: document.verify.claim_data.value , timestamp: document.verify.timestamp.value } } , function ( data )
        {
            console.log ( data );
            if ( data.errnum == 0 )
            {
                document.verify.proof.value = serializeObject ( data.data );
                document.verify.did.value = data.did;
                document.verify.action = verifierUrl;
                document.verify.submit();
            }
        } );
    }

}

function dataReceived ( data )
{
    if ( data.errnum == 0 )
    {
        claim_data = data.data.value.claim;
        if ( typeof claim_data.credentialSubject.file_key != 'undefined' && typeof claim_data.credentialSubject.name != 'undefined' && typeof claim_data.credentialSubject.type != 'undefined' )
        {
            filesReading ++;
            sendCommand ( 'loadFile' , { key: claim_data.credentialSubject.file_key , returnData: { field: '' } } , function ( data ) 
            {
                if ( typeof data == 'undefined' || typeof data.errnum == 'undefined' || data.errnum || typeof data.data == 'undefined' || typeof data.returnData == 'undefined' || typeof data.returnData.field == 'undefined' || data.returnData.field != '' )
                {
                    return;
                }
    
                claim_data.credentialSubject = data.data;
                filesReading--;
            } );
            sendVerification();
        }
        else
        {
            for ( var i in claim_data.credentialSubject )
            {
                if ( typeof claim_data.credentialSubject[i].file_key != 'undefined' && typeof claim_data.credentialSubject[i].name != 'undefined' && typeof claim_data.credentialSubject[i].type != 'undefined' )
                {
                    filesReading ++;
                    sendCommand ( 'loadFile' , { key: claim_data.credentialSubject[i].file_key , returnData: { field: i } } , function ( data ) 
                    {
                        if ( typeof data == 'undefined' || typeof data.errnum == 'undefined' || data.errnum || typeof data.data == 'undefined' || typeof data.returnData == 'undefined' || typeof data.returnData.field == 'undefined' || data.returnData.field == '' )
                        {
                            return;
                        }
            
                        claim_data.credentialSubject[data.returnData.field] = data.data;
                        filesReading--;
                    } );
                }
            }
            sendVerification();
        }
     }
 }
 jQuery ( document ).ready ( function()
 {
     if ( typeof params.claim != 'undefined' )
     {
        sendCommand ( 'getClaim' , { claimType: params.type , claim: params.claim } , dataReceived );
     }
 } );
  